<?php
/**
 * Framework heading field file.
 *
 * @link       https://shapedplugin.com/
 * @since      1.0.0
 *
 * @package    Woo_Category_Slider
 * @subpackage Woo_Category_Slider/admin/partials/section/settings
 * @author     ShapedPlugin <support@shapedplugin.com>
 */

if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access directly.

if ( ! class_exists( 'SP_WCS_Field_image_select' ) ) {
	/**
	 *
	 * Field: image_select
	 *
	 * @since 1.0.0
	 * @version 1.0.0
	 */
	class SP_WCS_Field_image_select extends SP_WCS_Fields {
		/**
		 * Field constructor.
		 *
		 * @param array  $field The field type.
		 * @param string $value The values of the field.
		 * @param string $unique The unique ID for the field.
		 * @param string $where To where show the output CSS.
		 * @param string $parent The parent args.
		 */
		public function __construct( $field, $value = '', $unique = '', $where = '', $parent = '' ) {
			parent::__construct( $field, $value, $unique, $where, $parent );
		}

		/**
		 * Render
		 *
		 * @return void
		 */
		public function render() {

			$args = wp_parse_args(
				$this->field,
				array(
					'multiple'    => false,
					'option_name' => false,
					'options'     => array(),
				)
			);

			$value = ( is_array( $this->value ) ) ? $this->value : array_filter( (array) $this->value );

			echo wp_kses_post( $this->field_before() );

			if ( ! empty( $args['options'] ) ) {

				echo '<div class="spf-siblings spf--image-group" data-multiple="' . esc_attr( $args['multiple'] ) . '">';

				$num = 1;

				foreach ( $args['options'] as $key => $option ) {

					$type          = ( $args['multiple'] ) ? 'checkbox' : 'radio';
					$extra         = ( $args['multiple'] ) ? '[]' : '';
					$option_name   = ( $args['option_name'] ) ? '<p>' . $option['option_name'] . '</p>' : '';
					$active        = ( in_array( $key, $value, true ) ) ? ' spf--active' : '';
					$checked       = ( in_array( $key, $value, true ) ) ? ' checked' : '';
					$pro_only      = isset( $option['pro_only'] ) ? ' disabled' : '';
					$opt_class     = isset( $option['class'] ) && ! empty( $option['class'] ) ? $option['class'] : '';
					$pro_only_text = isset( $option['pro_only'] ) ? '<strong class="wcs-pro-only">' . esc_html__( 'PRO', 'woo-category-slider-grid' ) . '</strong>' : '';
					echo '<div class="spf--sibling spf--image' . esc_attr( $active . ' ' . $opt_class ) . '">';
					echo '<div class="spf--image-area">';
					echo '<img src="' . esc_url( $option['image'] ) . '" alt="img-' . esc_attr( $num++ ) . '" />';
					echo '<input ' . esc_attr( $pro_only ) . ' type="' . esc_attr( $type ) . '" name="' . esc_attr( $this->field_name( $extra ) ) . '" value="' . esc_attr( $key ) . '"' . wp_kses_post( $this->field_attributes() . $checked ) . '/>' . wp_kses_post( $pro_only_text ) . '';
					echo '</div>';

					if ( isset( $option['option_demo_url'] ) ) {
						echo '<p class="category-pro-img-title">' . esc_html( $option['option_name'] ) . '<a href="' . esc_url( $option['option_demo_url'] ) . '" tooltip="Demo" class="wcsp-live-demo-icon" target="_blank"><i class="wcsp-icon-demo_link"></i></a></p>';
					}
					if ( isset( $option['option_name'] ) && ! isset( $option['option_demo_url'] ) ) {
						echo '<p class="text-center">' . wp_kses_post( $option_name ) . '</p>';
					}
					echo '</div>';
				}
				echo '</div>';
			}
			echo '<div class="clear"></div>';
			echo wp_kses_post( $this->field_after() );
		}

		/**
		 * Output
		 *
		 * @return statement
		 */
		public function output() {

			$output    = '';
			$bg_image  = array();
			$important = ( ! empty( $this->field['output_important'] ) ) ? '!important' : '';
			$elements  = ( is_array( $this->field['output'] ) ) ? join( ',', $this->field['output'] ) : $this->field['output'];

			if ( ! empty( $elements ) && isset( $this->value ) && '' !== $this->value ) {
				$output = $elements . '{background-image:url(' . $this->value . ')' . $important . ';}';
			}
			$this->parent->output_css .= $output;
			return $output;
		}
	}
}
